const DocMenuConfig = [
  {
    heading: "Getting Started",
    pages: [
      {
        heading: "Overview",
        route: "/doc-overview",
      },
      {
        heading: "Build",
        route: "/build",
      },
      {
        heading: "Setup theme skeleton",
        route: "/setup-theme-skeleton",
      },
      {
        heading: "Vue + Laravel integration",
        route: "/vue-laravel-integration",
      },
      {
        heading: "Internationalization (i18n)",
        route: "/internationalization",
      },
      {
        heading: "Dark mode",
        route: "/dark-mode",
      },
      {
        heading: "Vue Right-to-Left (RTL)",
        route: "/rtl",
      },
      {
        heading: "Updates",
        route: "/updates",
      },
      {
        heading: "Changelog",
        route: "/changelog",
      },
    ],
  },
  {
    heading: "Base",
    pages: [
      {
        heading: "Utilities",
        route: "/utilities",
      },
      {
        sectionTitle: "Helpers",
        route: "/helpers",
        sub: [
          {
            heading: "Flex Layots",
            route: "/helpers/flex-layouts",
          },
          {
            heading: "Text",
            route: "/helpers/text",
          },
          {
            heading: "Background",
            route: "/helpers/background",
          },
          {
            heading: "Borders",
            route: "/helpers/borders",
          },
        ],
      },
      {
        heading: "Forms",
        route: "/forms",
      },
      {
        heading: "Buttons",
        route: "/buttons",
      },
      {
        heading: "Indicator",
        route: "/indicator",
      },
      {
        heading: "Rotate",
        route: "/rotate",
      },
      {
        heading: "Tables",
        route: "/tables",
      },
      {
        heading: "Cards",
        route: "/cards",
      },
      {
        heading: "Symbol",
        route: "/symbol",
      },
      {
        heading: "Badges",
        route: "/badges",
      },
      {
        heading: "Pulse",
        route: "/pulse",
      },
      {
        heading: "Bullets",
        route: "/bullets",
      },
      {
        heading: "Accordion",
        route: "/accordion",
      },
      {
        heading: "Carousel",
        route: "/carousel",
      },
      {
        heading: "Overlay",
        route: "/overlay",
      },
      {
        heading: "Separator",
        route: "/separator",
      },
      {
        heading: "Tabs",
        route: "/tabs",
      },
      {
        heading: "Breadcrumb",
        route: "/breadcrumb",
      },
      {
        heading: "Modal",
        route: "/modal",
      },
      {
        heading: "Pagination",
        route: "/pagination",
      },
    ],
  },
  {
    heading: "Forms",
    pages: [
      {
        heading: "Vue Multiselect",
        route: "/vue-select",
      },
      {
        heading: "VeeValidate",
        route: "/vee-validate",
      },
      {
        heading: "Vue Currency Input",
        route: "/vue-currency-input",
      },
    ],
  },
  {
    heading: "Editors",
    pages: [
      {
        heading: "Vue TinyMCE",
        route: "/tinymce",
      },
    ],
  },
  {
    heading: "General",
    pages: [
      {
        heading: "Vue Fullcalendar",
        route: "/fullcalendar",
      },
    ],
  },
  {
    heading: "Icons",
    pages: [
      {
        heading: "Duotune",
        route: "/icons/duotune",
      },
      {
        heading: "Bootstrap Icons",
        route: "/icons/bootstrap-icons",
      },
      {
        heading: "Font Awesome",
        route: "/icons/font-awesome",
      },
      {
        heading: "Line Awesome",
        route: "/icons/line-awesome",
      },
    ],
  },
  {
    heading: "Element UI",
    pages: [
      {
        sectionTitle: "Basic",
        route: "/basic",
        sub: [
          {
            heading: "Layout",
            route: "/element-ui/basic/layout",
          },
          {
            heading: "Layout Container",
            route: "/element-ui/basic/layout-container",
          },
          {
            heading: "Icon",
            route: "/element-ui/basic/icon",
          },
          {
            heading: "Button",
            route: "/element-ui/basic/button",
          },
          {
            heading: "Link",
            route: "/element-ui/basic/link",
          },
          {
            heading: "Space",
            route: "/element-ui/basic/space",
          },
        ],
      },
      {
        sectionTitle: "Form",
        route: "/form",
        sub: [
          {
            heading: "Radio",
            route: "/element-ui/form/radio",
          },
          {
            heading: "Checkbox",
            route: "/element-ui/form/checkbox",
          },
          {
            heading: "Input",
            route: "/element-ui/form/input",
          },
          {
            heading: "InputNumber",
            route: "/element-ui/form/input-number",
          },
          {
            heading: "Select",
            route: "/element-ui/form/select",
          },
          {
            heading: "Cascader",
            route: "/element-ui/form/cascader",
          },
          {
            heading: "Switch",
            route: "/element-ui/form/switch",
          },
          {
            heading: "Slider",
            route: "/element-ui/form/slider",
          },
          {
            heading: "TimePicker",
            route: "/element-ui/form/time-picker",
          },
          {
            heading: "TimeSelect",
            route: "/element-ui/form/time-select",
          },
          {
            heading: "DatePicker",
            route: "/element-ui/form/date-picker",
          },
          {
            heading: "DateTimePicker",
            route: "/element-ui/form/date-time-picker",
          },
          {
            heading: "Upload",
            route: "/element-ui/form/upload",
          },
          {
            heading: "Rate",
            route: "/element-ui/form/rate",
          },
          {
            heading: "ColorPicker",
            route: "/element-ui/form/color-picker",
          },
          {
            heading: "Transfer",
            route: "/element-ui/form/transfer",
          },
          {
            heading: "Form",
            route: "/element-ui/form/form",
          },
        ],
      },
      {
        sectionTitle: "Data",
        route: "/data",
        sub: [
          {
            heading: "Table",
            route: "/element-ui/data/table",
          },
          {
            heading: "Tag",
            route: "/element-ui/data/tag",
          },
          {
            heading: "Progress",
            route: "/element-ui/data/progress",
          },
          {
            heading: "Tree",
            route: "/element-ui/data/tree",
          },
          {
            heading: "Pagination",
            route: "/element-ui/data/pagination",
          },
          {
            heading: "Badge",
            route: "/element-ui/data/badge",
          },
          {
            heading: "Skeleton",
            route: "/element-ui/data/skeleton",
          },
          {
            heading: "Empty",
            route: "/element-ui/data/empty",
          },
        ],
      },
      {
        sectionTitle: "Notice",
        route: "/notice",
        sub: [
          {
            heading: "Alert",
            route: "/element-ui/notice/alert",
          },
          {
            heading: "Loading",
            route: "/element-ui/notice/loading",
          },
          {
            heading: "Message",
            route: "/element-ui/notice/message",
          },
          {
            heading: "MessageBox",
            route: "/element-ui/notice/message-box",
          },
          {
            heading: "Notification",
            route: "/element-ui/notice/notification",
          },
        ],
      },
      {
        sectionTitle: "Navigation",
        route: "/navigation",
        sub: [
          {
            heading: "Affix",
            route: "/element-ui/navigation/affix",
          },
          {
            heading: "NavMenu",
            route: "/element-ui/navigation/nav-menu",
          },
          {
            heading: "Tabs",
            route: "/element-ui/navigation/tabs",
          },
          {
            heading: "Breadcrumb",
            route: "/element-ui/navigation/breadcrumb",
          },
          {
            heading: "PageHeader",
            route: "/element-ui/navigation/page-header",
          },
          {
            heading: "Dropdown",
            route: "/element-ui/navigation/dropdown",
          },
          {
            heading: "Steps",
            route: "/element-ui/navigation/steps",
          },
        ],
      },
    ],
  },
];

export default DocMenuConfig;
